#include <stdio.h>
#include <math.h>

double dist(double x1, double y1, double x2, double y2) {
    return sqrt((x1 - x2)*(x1 - x2) + (y1 - y2)*(y1 - y2));
}

int main() {
    int n;
    int x[1000], h[1000];

    scanf("%d", &n);
    for (int i = 0; i < n; i++) scanf("%d", &x[i]);
    for (int i = 0; i < n; i++) scanf("%d", &h[i]);

    for (int i = 0; i < n; i++) {
        double best = -1;

        for (int j = 0; j < n; j++) {
            if (j == i) continue;
            if (h[j] >= h[i]) {
                double d = dist(x[i], h[i], x[j], h[j]);
                if (best < 0 || d < best) best = d;
            }
        }

        for (int j = 0; j < n - 1; j++) {
            double xm = (x[j] + x[j+1] + h[j] - h[j+1]) / 2.0;
            double ym = h[j] - (xm - x[j]);
            if (ym < h[i]) continue;

            double xl = xm - (ym - h[i]);
            if (xl >= x[j] && xl <= xm) {
                double d = dist(x[i], h[i], xl, h[i]);
                if (best < 0 || d < best) best = d;
            }

            double xr = xm + (ym - h[i]);
            if (xr >= xm && xr <= x[j+1]) {
                double d = dist(x[i], h[i], xr, h[i]);
                if (best < 0 || d < best) best = d;
            }
        }

        if (best < 0)
            printf("-1\n");
        else
            printf("%.6f\n", best);
    }

    return 0;
}